<?php
/*
Plugin Name: Whitelable SMS Plugin
Version: 1.0.0
Plugin URI: #
Description: Sends SMS notifications to your clients for order status changes. You can also receive an SMS message when a new order is received.
Author URI: #
Author: #
Requires at least: 3.8
Tested up to: 5.5.3
*/

//Exit if accessed directly
error_reporting(0);
if (!defined('ABSPATH')) {
    exit();
}
global $wpdb, $whitelablesms_db_version, $whitelablesms_db_table;
$whitelablesms_db_version = 1.73;
$whitelablesms_db_table = $wpdb->prefix . 'whitelablesms_cart_notifications';

//Define text domain
$whitelablesms_plugin_name = 'WooCommerce SMS Notification';
$whitelablesms_plugin_file = plugin_basename(__FILE__);
$whitelablesms_plugin_domn = 'whitelablesms';
load_plugin_textdomain($whitelablesms_plugin_domn, false, dirname($whitelablesms_plugin_file) . '/languages');

//Add links to plugin listing
add_filter("plugin_action_links_$whitelablesms_plugin_file", 'whitelablesms_add_action_links');
function whitelablesms_add_action_links($links)
{
    global $whitelablesms_plugin_domn;
    $links[] = '<a href="' . admin_url("admin.php?page=$whitelablesms_plugin_domn") . '">Settings</a>';
    $links[] = '<a href="#" target="_blank">Plugin Documentation</a>';
    return $links;
}

//Add links to plugin settings page
add_filter('plugin_row_meta', "whitelablesms_plugin_row_meta", 10, 2);
function whitelablesms_plugin_row_meta($links, $file)
{
    global $whitelablesms_plugin_file;
    if (strpos($file, $whitelablesms_plugin_file) !== false) {
        $links[] = '<a href="#" target="_blank">Get Credentials</a>';
        $links[] = '<a href="#" target="_blank">Plugin Documentation</a>';
    }
    return $links;
}

//WooCommerce is required for the plugin to work
if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    include('plugin-core.php');
} else {
    add_action('admin_notices', 'whitelablesms_require_wc');
    function whitelablesms_require_wc()
    {
        global $whitelablesms_plugin_name, $whitelablesms_plugin_domn;
        echo '<div class="error fade" id="message"><h3>' . $whitelablesms_plugin_name . '</h3><h4>' . __("This plugin requires WooCommerce", $whitelablesms_plugin_domn) . '</h4></div>';
        deactivate_plugins($whitelablesms_plugin_file);
    }
}

//Handle uninstallation
register_uninstall_hook(__FILE__, 'whitelablesms_uninstaller');
function whitelablesms_uninstaller()
{
    delete_option('whitelablesms_settings');
}

//Create table on activation / update
register_activation_hook(__FILE__, 'whitelablesms_db_install');
function whitelablesms_db_install()
{
    global $wpdb, $whitelablesms_db_version, $whitelablesms_db_table;
    if ($whitelablesms_db_version == get_option('whitelablesms_db_version')) {
        return;
    }

    //Use WP built-in functionality to create tables
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    $charset_collate = $wpdb->get_charset_collate();

    //Create required tables
    $sql = "CREATE TABLE $whitelablesms_db_table (
        billing_phone varchar(15) NOT NULL,
        first_name varchar(255) NOT NULL,
        order_id bigint(20) unsigned NOT NULL DEFAULT 0,
        register_ts datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
        msg_sent tinyint(1) unsigned NOT NULL DEFAULT 0,
        reminder_1_sent tinyint(1) unsigned NOT NULL DEFAULT 0,
        reminder_2_sent tinyint(1) unsigned NOT NULL DEFAULT 0,
        reminder_3_sent tinyint(1) unsigned NOT NULL DEFAULT 0,
        reminder_4_sent tinyint(1) unsigned NOT NULL DEFAULT 0,
        reminder_5_sent tinyint(1) unsigned NOT NULL DEFAULT 0,
        reminder_6_sent tinyint(1) unsigned NOT NULL DEFAULT 0,
        reminder_7_sent tinyint(1) unsigned NOT NULL DEFAULT 0,
        reminder_8_sent tinyint(1) unsigned NOT NULL DEFAULT 0,
        reminder_9_sent tinyint(1) unsigned NOT NULL DEFAULT 0,
        reminder_10_sent tinyint(1) unsigned NOT NULL DEFAULT 0,
		PRIMARY KEY  (billing_phone),
        KEY resiter_ts_key (register_ts)
	) $charset_collate;";
    dbDelta($sql);

    //Update the db version
    update_option('whitelablesms_db_version', $whitelablesms_db_version);
}

//Create a WP-Cron interval of 5 minutes
add_filter( 'cron_schedules', 'whitelablesms_add_cron_interval' );
function whitelablesms_add_cron_interval( $schedules ) { 
    if ( empty( $schedules['five_minutes'] ) ) {
        $schedules['five_minutes'] = array(
            'interval' => 5 * 60,
            'display'  => esc_html__( 'Every Five Minutes' ),
        );
    }
    return $schedules;
}

//Schedule the hook
register_activation_hook(__FILE__, 'whitelablesms_schedule_cron');
function whitelablesms_schedule_cron() {
    if ( ! wp_next_scheduled( 'whitelablesms_cron_hook' ) ) {
        $res = wp_schedule_event( time(), 'five_minutes', 'whitelablesms_cron_hook' );
        if ( ! $res ) wp_die( 'Failed to schedule whitelablesms_cron_hook' );
    }
}

//Disable cron on plugin deactivation
register_deactivation_hook( __FILE__, 'whitelablesms_cron_deactivate' ); 
function whitelablesms_cron_deactivate() {
    if ( wp_next_scheduled( 'whitelablesms_cron_hook' ) ) {
        $timestamp = wp_next_scheduled( 'whitelablesms_cron_hook' );
        wp_unschedule_event( $timestamp, 'whitelablesms_cron_hook' );
    }
}

//Apply activation functions for upgrades as well
add_action( 'upgrader_process_complete', 'whitelablesms_post_upgrade', 10, 2 );
function whitelablesms_post_upgrade( $_, $options ) {
    global $whitelablesms_plugin_file;
    if ( 'update' == $options['action'] && 'plugin' == $options['type'] ) {
        foreach ( $options['plugins'] as $plugin ) {
            if ( $plugin == $whitelablesms_plugin_file ) {
                whitelablesms_db_install();
                whitelablesms_schedule_cron();
            }
        }        
    }
}
